//
//  CMDemoViewController.m
//  CMDemo
//
//  Created by Jonathan Diehl on 31.05.11.
//  Copyright 2011 RWTH. All rights reserved.
//

// the update frequency
#define kUpdateFrequency 30.0

#import "CMDemoViewController.h"

@implementation CMDemoViewController

@synthesize gravityX, gravityY, gravityZ;
@synthesize userX, userY, userZ;


// this methos is called frequently by the timer
- (void)update:(NSTimer *)theTimer;
{
	CMDeviceMotion *motion = manager.deviceMotion;
	CMAcceleration gravity = motion.gravity;
	CMAcceleration user = motion.userAcceleration;
	
	// update the UI
	gravityX.progress = 0.5 + gravity.x/2.0;
	gravityY.progress = 0.5 + gravity.y/2.0;
	gravityZ.progress = 0.5 + gravity.z/2.0;
	userX.progress = 0.5 + user.x/2.0;
	userY.progress = 0.5 + user.y/2.0;
	userZ.progress = 0.5 + user.z/2.0;
}


#pragma mark UIViewController

// init view
- (void)viewDidLoad
{
    [super viewDidLoad];
	
	// init the core motion manager
	manager = [[CMMotionManager alloc] init];
	manager.deviceMotionUpdateInterval = 1.0/kUpdateFrequency;
}

// did appear
- (void)viewDidAppear:(BOOL)animated;
{
	// start reading gyro data
	[manager startDeviceMotionUpdates];
	
	// start timer
	timer = [[NSTimer scheduledTimerWithTimeInterval:1.0/kUpdateFrequency target:self selector:@selector(update:) userInfo:nil repeats:YES] retain];
}

// will disappear
- (void)viewWillDisappear:(BOOL)animated;
{
	// stop gyro updates
	[manager stopDeviceMotionUpdates];
	
	// stop the timer
	[timer invalidate];
	[timer release];
}

// clean up
- (void)dealloc
{
	[timer invalidate];
	[timer release];
	
	[manager release];
    [super dealloc];
}

@end
